<?php
/* --------------------------------------------------------------
   SqlSorting.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Criteria;

/**
 * Interface SqlSorting
 *
 * @package Gambio\Core\SqlCriteria\Interfaces
 */
interface SqlSorting
{
    /**
     * Returns the column name.
     *
     * @return string
     */
    public function column(): string;
    
    
    /**
     * Returns the order (asc or desc).
     *
     * @return string
     */
    public function order(): string;
}